(* ::Package:: *)

(* ::Input::Initialization:: *)
(*Hamiltonian and Variables*)
ns=2;
bb3=generateBasis[ns,{}];
Remove[gammaMatrix1,\[CapitalGamma]1,\[CapitalGamma]2,gammaMatrix2,\[CapitalGamma]12,\[CapitalGamma]12b,gate,\[Epsilon]1up,\[Epsilon]1dn,\[Epsilon]2up,\[Epsilon]2dn,B,Um,U11,U12,U22,VSD,V1,V2,\[CapitalDelta]SD,\[CapitalDelta]1,\[CapitalDelta]2];
gammaMatrix1={{{1,1},\[CapitalGamma]1},{{2,1},\[CapitalGamma]1},{{1,2},\[CapitalGamma]2},{{2,2},\[CapitalGamma]2}};
gammaMatrix2={{{1,1},{1,2},-\[CapitalGamma]12},{{2,1},{2,2},-\[CapitalGamma]12},{{1,2},{1,1},\[CapitalGamma]12},{{2,2},{2,1},\[CapitalGamma]12},{{1,1},{2,2},-\[CapitalGamma]12b},{{2,1},{1,2},-\[CapitalGamma]12b},{{1,2},{2,1},\[CapitalGamma]12b},{{2,2},{1,1},\[CapitalGamma]12b}};
gate={{\[Epsilon]1up-B/2,\[Epsilon]2up-B/2},{\[Epsilon]1dn+B/2,\[Epsilon]2dn+B/2}};
Um={{U11,U12},{U12,U22}};
VSD={V1,V2};
\[CapitalDelta]SD={\[CapitalDelta]1,\[CapitalDelta]2};
H=SparseArray[constructHsite[bb3,gate[[1]],gate[[2]]]]+SparseArray[constructHinteractions[bb3,Um]]+SparseArray[constructHCP[bb3,VSD]];
HA=constructHAndreev[bb3,\[CapitalDelta]SD];


(* ::Input::Initialization:: *)
(*Update some functions from ieGen v3.m*)
pStep[x_]:=0.5` (1+Tanh[x/(2*T)])
Remove[nF];
nF[i_,x_,\[Beta]_]:=If[i==2,1/(E^(\[Beta] x)+1),1/(E^(\[Beta] x)+1)]

generateElasticTransitionRates[states_,gammaMatrix1_,eME_,tInv_]:=Module[{res,\[Alpha],\[Beta]},(*we want to generate the transition rate \[Alpha]\[Rule]\[Beta].The main hurdle to overcome is the energy shifts,as we already have the matrix elements... Make sure the sign of the step function is OK*)Table[Sum[If[eME[[i,\[Beta],\[Alpha]]]!=0,(eME[[i,\[Beta],\[Alpha]]])*gammaMatrix1[[i,2]]*nF[gammaMatrix1[[i,1,2]],-(states[[\[Alpha],1]]-states[[\[Beta],1]]),tInv],0],{i,Length[gammaMatrix1]}],{\[Alpha],Length[states]},{\[Beta],Length[states]}]]

computeCurrent2[bb3_,gate_,Um_,VSD_,\[CapitalDelta]SD_,gammaMatrix1_,gammaMatrix2_,\[Beta]_]:=Module[{H,HA,states,st,eME,iME,Tem,Tim,Jim,Ttot,es0,es,jt,dDagger,d,p},H=SparseArray[constructHsite[bb3,gate[[1]],gate[[2]]]]+SparseArray[constructHinteractions[bb3,Um]]+SparseArray[constructHCP[bb3,VSD]];
HA=constructHAndreev[bb3,\[CapitalDelta]SD];
states=Chop[Sort[Transpose[Eigensystem[H+HA]]]];
st={#[[1]],bb3[[Ordering[Abs[#[[2]]],-1][[1]]]]}&/@states;
{dDagger,d}=constructRaisingLoweringPartial[bb3];
eME=generateElasticME[states,gammaMatrix1,d,dDagger];
iME=generateInelasticME[states,gammaMatrix2,d,dDagger];
Tem=generateElasticTransitionRates[states,gammaMatrix1,eME,\[Beta]];
Tim=generateInelasticTransitionRates[bb3,VSD,states,gammaMatrix2,iME];
Jim=Transpose[Chop[generateInelasticCurrent[bb3,VSD,states,gammaMatrix2,iME]]];
Ttot=Chop[Transpose[Tem]+Transpose[Tim]];
Do[Ttot[[i,i]]=-Total[Ttot[[All,i]]];,{i,Length[Ttot]}];
es0=Eigensystem[Ttot];
es0[[1]]=Abs[es0[[1]]];
es0=Sort[Transpose[es0]];
es=es0[[1]];
p=es[[2]]/Total[es[[2]]];
jt=Total[Jim.p];
Return[jt];];

GSposition[bb3_,gate_,Um_,VSD_,\[CapitalDelta]SD_,gammaMatrix1_,gammaMatrix2_,\[Beta]_]:=Module[{H,HA,states,st,eME,iME,Tem,Tim,Jim,Ttot,es0,es,jt,dDagger,d,p},H=SparseArray[constructHsite[bb3,gate[[1]],gate[[2]]]]+SparseArray[constructHinteractions[bb3,Um]]+SparseArray[constructHCP[bb3,VSD]];
HA=constructHAndreev[bb3,\[CapitalDelta]SD];
states=Chop[Sort[Transpose[Eigensystem[H+HA]]]];
st=states[[1]];
Return[Ordering[Abs[st[[2]]],-1][[-1]]]]

(*Other functions and variables*)
filecount=0;
secNum=100;

saveData[z_]:=(printParameters[];
If[filecount>0,Export[ToString[filecount]<>".json",(#[[1]]->ToString[#[[2]]//InputForm])&/@getParameters[]];
Export[ToString[filecount++]<>".txt",Re[z],"Table"];];)

myPlot[z_]:=MatrixPlot[z//Reverse,PlotRange->All,DataRange->{{xlist[[1]],xlist[[-1]]},{ylist[[1]],ylist[[-1]]}},FrameLabel->{ylabel,xlabel}(*weird order...*),PlotLegends->Automatic]

myPlot2[z_,para_:{}]:=ArrayPlot[z//Reverse,para,PlotRange->All,DataRange->{{xlist[[1]],xlist[[-1]]},{ylist[[1]],ylist[[-1]]}},FrameLabel->{ylabel,xlabel}(*weird order...*),PlotLegends->Automatic,ColorFunction->(Blend[{Blue,White,Red},#]&),FrameTicks->All]

myPlotC[z_,para_:{}]:=(ListContourPlot[z,para,DataRange->{{xlist[[1]],xlist[[-1]]},{ylist[[1]],ylist[[-1]]}},FrameLabel->{xlabel,ylabel},FrameTicks->Automatic,ContourShading->None])

yderiv[z0_,dy_]:=Block[{a,b,z},(*z0:2d array*)z=z0;
a=(z[[2]]-z[[1]])/dy;
b=(z[[-1]]-z[[-2]])/dy;
z[[2;;-2]]=(z[[3;;-1]]-z[[1;;-3]])/dy/2.;
z[[1]]=a;
z[[-1]]=b;
z]

initParameters[]:=( 
T=1.*10^-5;
B=5.*10^-4;
{\[Epsilon]1up,\[Epsilon]1dn,\[Epsilon]2up,\[Epsilon]2dn}={0,0,0,0};
{U11,U22,U12}={1.,1.,0.1};
{V1,V2}={0.1,-0.1};
{\[CapitalDelta]1,\[CapitalDelta]2}={0.,0.25};
{\[CapitalGamma]1,\[CapitalGamma]2,\[CapitalGamma]12,\[CapitalGamma]12b}={0.01,0.0,0.0242134,0.0};
)

getParameters[]:=Block[{lead,x,\[Beta]},{
"File #"->filecount,
"T"->T,
"B"->B,
"{\[Epsilon]1up,\[Epsilon]1dn,\[Epsilon]2up,\[Epsilon]2dn}"->{\[Epsilon]1up,\[Epsilon]1dn,\[Epsilon]2up,\[Epsilon]2dn},
"{U11,U22,U12}"->{U11,U22,U12},
"{V1,V2}"->{V1,V2},
"{\[CapitalDelta]1,\[CapitalDelta]2}"->{\[CapitalDelta]1,\[CapitalDelta]2},
"{\[CapitalGamma]1,\[CapitalGamma]2,\[CapitalGamma]12,\[CapitalGamma]12b}"->{\[CapitalGamma]1,\[CapitalGamma]2,\[CapitalGamma]12,\[CapitalGamma]12b},
"nF"->nF[lead,x,\[Beta]],
"DOSlead2"->DOSlead2,
"\[CapitalDelta]lead2"->\[CapitalDelta]lead2,
"lcut"->lcut,
"x"->{xlabel,xlist[[1]],xlist[[-1]],Length[xlist]},"y"->{ylabel,ylist[[1]],ylist[[-1]],Length[ylist]}}]

printParameters[]:=Print[getParameters[]//TableForm]

(*calculate points that is useful for the linecuts*)
keyPoints[]:=(pt1={-U11,-U22/2-Sqrt[U22*U22/4-\[CapitalDelta]2*\[CapitalDelta]2]}-{2,2}*U12;
pt2={-U11,-U22/2+Sqrt[U22*U22/4-\[CapitalDelta]2*\[CapitalDelta]2]}-{1,2}*U12;
pt3={0,-U22/2+Sqrt[U22*U22/4-\[CapitalDelta]2*\[CapitalDelta]2]}-{1,1}*U12;
pt4={0,-U22/2-Sqrt[U22*U22/4-\[CapitalDelta]2*\[CapitalDelta]2]}-{2,1}*U12;)


(* ::Input::Initialization:: *)
(*convert basis to string, {{0,1},{0,0}}\[Rule]String|0,\[UpArrow]>*)bbStr[b_]:=Block[{temp},temp={If[b[[1,1]]==0,"","\[UpArrow]"]<>If[b[[2,1]]==0,"","\[DownArrow]"],If[b[[1,2]]==0,"","\[UpArrow]"]<>If[b[[2,2]]==0,"","\[DownArrow]"]};
temp=Table[If[i=="","0",i],{i,temp}];
"|"<>StringRiffle[ToString/@temp,","]<>">"]

(*convert states to string, {a,b,...}\[Rule]{a|0,0>,b|0,\[DownArrow]>,...}*)
stateStr[psi_]:=Block[{ind,amp,str},ind=Position[psi,_?(#!=0&)]//Flatten;
str=bbStr/@bb3[[ind]];
amp=psi[[ind]];
Return@Table[ToString@amp[[i]]<>str[[i]],{i,Range[Length[ind]]}];]

(*sort the eigenstates*)
groupE[e_,\[CapitalPsi]_]:=Block[{ind},(*Set to 0.1 so there will be an warning if an index is not set.*)ind=Table[0.1,{i,16}];
Do[Switch[Flatten@Position[\[CapitalPsi][[i]],_?(#!=0&)],
(*|0,E>*)
{1,6},If[\[CapitalPsi][[i]][[1]]*\[CapitalPsi][[i]][[6]]<0,ind[[1]]=i,ind[[2]]=i];,
(*|0,1>:0\[DownArrow],0\[UpArrow]*)
{2},ind[[3]]=i;,
{5},ind[[4]]=i;,
(*|1,Even>*)
{3,8},If[\[CapitalPsi][[i]][[3]]*\[CapitalPsi][[i]][[8]]<0,ind[[5]]=i,ind[[6]]=i];,
{9,14},If[\[CapitalPsi][[i]][[9]]*\[CapitalPsi][[i]][[14]]<0,ind[[7]]=i,ind[[8]]=i];,
(*|1,1>: \[DownArrow]\[DownArrow],\[DownArrow]\[UpArrow],\[UpArrow]\[DownArrow],\[UpArrow]\[UpArrow]*)
{4},ind[[9]]=i;,
{7},ind[[10]]=i;,
{10},ind[[11]]=i;,
{13},ind[[12]]=i;,
(*|2,Even>*)
{11,16},If[\[CapitalPsi][[i]][[11]]*\[CapitalPsi][[i]][[16]]<0,ind[[13]]=i,ind[[14]]=i];,
(*|2,1>:2\[DownArrow],2\[UpArrow]*)
{12},ind[[15]]=i;,
{15},ind[[16]]=i;],{i,Range[Length[\[CapitalPsi]]]}];
If[Length[Select[ind,#==0.1&]]>0,Print["Error",ind,Table[Position[i,_?(#!=0&)]//Flatten,{i,\[CapitalPsi]}],stateStr/@\[CapitalPsi]];
printParameters[];];
Return[{e[[ind]],\[CapitalPsi][[ind]]}]]

getDeltaE[Exy_,ylist_]:=Block[{E0E,E01,E1E,E11,E2E,E2Ep,E21,dE},
E0E=Map[Min,Exy[[All,All,1;;2]],{2}];
E01=Map[Min,Exy[[All,All,3;;4]],{2}];
E1E=Map[Min,Exy[[All,All,5;;8]],{2}];
E11=Map[Min,Exy[[All,All,9;;12]],{2}];E2E=Map[Min,Exy[[All,All,13;;14]],{2}];E2Ep=Map[Max,Exy[[All,All,13;;14]],{2}];E21=Map[Min,Exy[[All,All,15;;16]],{2}];

dE=Table[None,{i,4}];
dE[[1]]=E11-E0E+2 ylist;
dE[[2]]=E0E-E1E;
dE[[3]]=E1E-E01+2 ylist;
dE[[4]]=E01-E11;
Return[dE];
]
